﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:htd4="urn:org:ebics:H004" xmlns:htd="http://www.ebics.org/H003" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" encoding="UTF-8" omit-xml-declaration="yes"/>
	<xsl:param name="DownloadBase"></xsl:param>
	<xsl:param name="BankName"></xsl:param>

	<!--
		Alle nicht abgehandelten Nodes landen hier und es passiert damit nichts
	-->
	<xsl:template match="*">
	</xsl:template>


	<xsl:template match="htd:HTDResponseOrderData">
		<html>
			<head>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">..\dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">..\..\dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="META">
				<xsl:attribute name="http-equiv">Content-Type</xsl:attribute>
				<xsl:attribute name="content">text/html; charset=UTF-8</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			</head>
			<BODY class="main">
				<table width="100%" cellspacing="0">
				<tr>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
				</tr>
				<tr><th colspan="10"><h2><xsl:value-of select="$BankName"></xsl:value-of></h2></th></tr>
				<xsl:apply-templates select="htd:PartnerInfo"/>
				<xsl:apply-templates select="htd:UserInfo"/>
				</table>
			</BODY>
		</html>
	</xsl:template>

	<xsl:template match="htd:PartnerInfo">
		<xsl:apply-templates select="htd:AddressInfo"/>
		<xsl:apply-templates select="htd:BankInfo"/>
		<xsl:if test="htd:AccountInfo">
			<xsl:call-template name="Header2">
				<xsl:with-param name="Label">Kontoinformationen</xsl:with-param>
			</xsl:call-template>
			<tr>
				<th class="light" align="left" colspan="1"><h4>Währung</h4></th>
				<th class="light" align="left"  colspan="3"><h4>Konto-ID</h4></th>
				<th class="light" align="left"  colspan="2"><h4>Bank</h4></th>
				<th class="light" align="left"  colspan="4"><h4>Kontonummer</h4></th>
			</tr>
			<xsl:apply-templates select="htd:AccountInfo"/>
		</xsl:if>
		<xsl:if test="htd:OrderInfo">
			<xsl:call-template name="Header2">
				<xsl:with-param name="Label">Auftragsarten</xsl:with-param>
			</xsl:call-template>
			<tr>
				<th class="light" align="left" colspan="1"><h4>Auftragsart</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Richtung</h4></th>
				<th class="light" align="left"  colspan="1"><h4>EU-Soll</h4></th>
				<th class="light" align="left"  colspan="7"><h4>Bezeichnung</h4></th>
			</tr>
			<xsl:apply-templates select="htd:OrderInfo"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="htd:UserInfo">
		<tr>
			<td colspan="10"><br/></td>
		</tr>
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Benutzer</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="1"><h4>Benutzer</h4></th>
			<th class="light" align="left"  colspan="3"><h4>Name</h4></th>
			<th class="light" align="left"  colspan="6"><h4>Status</h4></th>
		</tr>
		<tr>
			<td colspan="1"><xsl:value-of select="htd:UserID"/></td>
			<td colspan="3"><xsl:value-of select="htd:Name"/></td>
			<td colspan="6">
				<xsl:if test="htd:UserID/@Status=1">Bereit</xsl:if>
				<xsl:if test="htd:UserID/@Status=2">Neu</xsl:if>
				<xsl:if test="htd:UserID/@Status=3">Teilweise initialisiert (INI)</xsl:if>
				<xsl:if test="htd:UserID/@Status=4">Teilweise initialisiert (HIA)</xsl:if>
				<xsl:if test="htd:UserID/@Status=5">Initialisiert</xsl:if>
				<xsl:if test="htd:UserID/@Status=6">Gesperrt, mehrmalige Fehlversuche</xsl:if>
				<xsl:if test="htd:UserID/@Status=7">Neu_FTAM</xsl:if>
				<xsl:if test="htd:UserID/@Status=8">Gesperrt, durch SPR-Auftrag </xsl:if>
				<xsl:if test="htd:UserID/@Status=9">Gesperrt, durch Bank</xsl:if>
			</td>
		</tr>
		<xsl:if test="htd:Permission">
			<xsl:call-template name="Header3">
				<xsl:with-param name="Label">Berechtigungen</xsl:with-param>
			</xsl:call-template>
			<tr>
				<td colspan="1"><xsl:text> </xsl:text></td>
				<th class="light" align="left" colspan="1"><h4>Auftragsart</h4></th>
				<th class="light" align="left"  colspan="1"><h4>U-Klasse</h4></th>
				<th class="light" align="left"  colspan="5"><h4>Konto-ID</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Währung</h4></th>
				<th class="light" align="right"  colspan="1"><h4>Höchstbetrag</h4></th>
			</tr>
			<xsl:apply-templates select="htd:Permission"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Header2">
		<xsl:param name="Label"/>
		<tr>
			<td colspan="10"><br/></td>
		</tr>
		<tr>
			<th class="dark" align="left" colspan="10"><xsl:value-of select="$Label"/>:</th>
		</tr>
	</xsl:template>

	<xsl:template name="Header3">
		<xsl:param name="Label"/>
		<tr>
			<td colspan="10"><br/></td>
		</tr>
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<th class="dark" align="left" colspan="9"><xsl:value-of select="$Label"/>:</th>
		</tr>
	</xsl:template>

	<xsl:template match="htd:AddressInfo">
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Adresse</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="10"><h4>Name und Adresse</h4></th>
		</tr>
		<tr>
			<td colspan="10">
				<xsl:value-of select="htd:Name"/>
				<xsl:if test="htd:Street">
					, <xsl:value-of select="htd:Street"/>
				</xsl:if>
				<xsl:if test="htd:PostCode">
					, <xsl:value-of select="htd:Country"/> <xsl:value-of select="htd:Region"/> <xsl:value-of select="htd:PostCode"/> <xsl:value-of select="htd:City"/>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="htd:BankInfo">
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Informationen zur Bank</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="10"><h4>Hostname</h4></th>
		</tr>
		<tr>
			<td colspan="10"><xsl:value-of select="htd:HostID"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="htd:AccountInfo">
		<tr>
			<td colspan="1"><xsl:value-of select="@Currency"/></td>
			<td colspan="3"><xsl:value-of select="@ID"/></td>
			<td colspan="2">
				<xsl:value-of select="htd:BankCode"/>
				<xsl:if test="htd:NationalBankCode">
					<br></br><xsl:value-of select="htd:NationalBankCode"/>
				</xsl:if>
			</td>
			<td colspan="4">
				<xsl:value-of select="htd:AccountNumber"/>
				<xsl:if test="htd:NationalAccountNumber">
					<br></br><xsl:value-of select="htd:NationalAccountNumber"/>
				</xsl:if>
			</td>
		</tr>
		<xsl:if test="htd:UsageOrderTypes">
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<td colspan="2">Auftragsarten:</td>
			<td colspan="7"><xsl:value-of select="htd:UsageOrderTypes"/></td>
		</tr>
		</xsl:if>
	</xsl:template>

	<xsl:template match="htd:OrderInfo">
		<tr>
			<td colspan="1"><xsl:value-of select="htd:OrderType"/></td>
			<td colspan="1"><xsl:value-of select="htd:TransferType"/></td>
			<td colspan="1"><xsl:value-of select="htd:NumSigRequired"/></td>
			<td colspan="7"><xsl:value-of select="htd:Description"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="htd:Permission">
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<td colspan="1"><xsl:value-of select="htd:OrderTypes"/></td>
			<td colspan="1"><xsl:value-of select="@AuthorisationLevel"/></td>
			<td colspan="5"><xsl:value-of select="htd:AccountID"/></td>
			<td colspan="1"><xsl:value-of select="htd:MaxAmount/@AuthorisationLevel"/></td>
			<td colspan="1" align="right"><xsl:value-of select="htd:MaxAmount"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="htd4:HTDResponseOrderData">
		<html>
			<head>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">..\dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">..\..\dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="META">
				<xsl:attribute name="http-equiv">Content-Type</xsl:attribute>
				<xsl:attribute name="content">text/html; charset=UTF-8</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			</head>
			<BODY class="main">
				<table width="100%" cellspacing="0">
				<tr>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
				</tr>
				<tr><th colspan="10"><h2><xsl:value-of select="$BankName"></xsl:value-of></h2></th></tr>
				<xsl:apply-templates select="htd4:PartnerInfo"/>
				<xsl:apply-templates select="htd4:UserInfo"/>
				</table>
			</BODY>
		</html>
	</xsl:template>

	<xsl:template match="htd4:PartnerInfo">
		<xsl:apply-templates select="htd4:AddressInfo"/>
		<xsl:apply-templates select="htd4:BankInfo"/>
		<xsl:if test="htd4:AccountInfo">
			<xsl:call-template name="Header2">
				<xsl:with-param name="Label">Kontoinformationen</xsl:with-param>
			</xsl:call-template>
			<tr>
				<th class="light" align="left" colspan="1"><h4>Währung</h4></th>
				<th class="light" align="left"  colspan="3"><h4>Konto-ID</h4></th>
				<th class="light" align="left"  colspan="2"><h4>Bank</h4></th>
				<th class="light" align="left"  colspan="4"><h4>Kontonummer</h4></th>
			</tr>
			<xsl:apply-templates select="htd4:AccountInfo"/>
		</xsl:if>
		<xsl:if test="htd4:OrderInfo">
			<xsl:call-template name="Header2">
				<xsl:with-param name="Label">Auftragsarten</xsl:with-param>
			</xsl:call-template>
			<tr>
				<th class="light" align="left" colspan="1"><h4>Auftragsart</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Richtung</h4></th>
				<th class="light" align="left"  colspan="1"><h4>EU-Soll</h4></th>
				<th class="light" align="left"  colspan="7"><h4>Bezeichnung</h4></th>
			</tr>
			<xsl:apply-templates select="htd4:OrderInfo"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="htd4:UserInfo">
		<tr>
			<td colspan="10"><br/></td>
		</tr>
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Benutzer</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="1"><h4>Benutzer</h4></th>
			<th class="light" align="left"  colspan="3"><h4>Name</h4></th>
			<th class="light" align="left"  colspan="6"><h4>Status</h4></th>
		</tr>
		<tr>
			<td colspan="1"><xsl:value-of select="htd4:UserID"/></td>
			<td colspan="3"><xsl:value-of select="htd4:Name"/></td>
			<td colspan="6">
				<xsl:if test="htd4:UserID/@Status=1">Bereit</xsl:if>
				<xsl:if test="htd4:UserID/@Status=2">Neu</xsl:if>
				<xsl:if test="htd4:UserID/@Status=3">Teilweise initialisiert (INI)</xsl:if>
				<xsl:if test="htd4:UserID/@Status=4">Teilweise initialisiert (HIA)</xsl:if>
				<xsl:if test="htd4:UserID/@Status=5">Initialisiert</xsl:if>
				<xsl:if test="htd4:UserID/@Status=6">Gesperrt, mehrmalige Fehlversuche</xsl:if>
				<xsl:if test="htd4:UserID/@Status=7">Neu_FTAM</xsl:if>
				<xsl:if test="htd4:UserID/@Status=8">Gesperrt, durch SPR-Auftrag </xsl:if>
				<xsl:if test="htd4:UserID/@Status=9">Gesperrt, durch Bank</xsl:if>
			</td>
		</tr>
		<xsl:if test="htd4:Permission">
			<xsl:call-template name="Header3">
				<xsl:with-param name="Label">Berechtigungen</xsl:with-param>
			</xsl:call-template>
			<tr>
				<td colspan="1"><xsl:text> </xsl:text></td>
				<th class="light" align="left" colspan="1"><h4>Auftragsart</h4></th>
				<th class="light" align="left"  colspan="1"><h4>U-Klasse</h4></th>
				<th class="light" align="left"  colspan="5"><h4>Konto-ID</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Währung</h4></th>
				<th class="light" align="right"  colspan="1"><h4>Höchstbetrag</h4></th>
			</tr>
			<xsl:apply-templates select="htd4:Permission"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="htd4:AddressInfo">
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Adresse</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="10"><h4>Name und Adresse</h4></th>
		</tr>
		<tr>
			<td colspan="10">
				<xsl:value-of select="htd4:Name"/>
				<xsl:if test="htd4:Street">
					, <xsl:value-of select="htd4:Street"/>
				</xsl:if>
				<xsl:if test="htd4:PostCode">
					, <xsl:value-of select="htd4:Country"/> <xsl:value-of select="htd4:Region"/> <xsl:value-of select="htd4:PostCode"/> <xsl:value-of select="htd4:City"/>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="htd4:BankInfo">
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Informationen zur Bank</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="10"><h4>Hostname</h4></th>
		</tr>
		<tr>
			<td colspan="10"><xsl:value-of select="htd4:HostID"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="htd4:AccountInfo">
		<tr>
			<td colspan="1"><xsl:value-of select="@Currency"/></td>
			<td colspan="3"><xsl:value-of select="@ID"/></td>
			<td colspan="2">
				<xsl:value-of select="htd4:BankCode"/>
				<xsl:if test="htd4:NationalBankCode">
					<br></br><xsl:value-of select="htd4:NationalBankCode"/>
				</xsl:if>
			</td>
			<td colspan="4">
				<xsl:value-of select="htd4:AccountNumber"/>
				<xsl:if test="htd4:NationalAccountNumber">
					<br></br><xsl:value-of select="htd4:NationalAccountNumber"/>
				</xsl:if>
			</td>
		</tr>
		<xsl:if test="htd4:UsageOrderTypes">
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<td colspan="2">Auftragsarten:</td>
			<td colspan="7"><xsl:value-of select="htd4:UsageOrderTypes"/></td>
		</tr>
		</xsl:if>
	</xsl:template>

	<xsl:template match="htd4:OrderInfo">
		<tr>
			<td colspan="1"><xsl:value-of select="htd4:OrderType"/></td>
			<td colspan="1"><xsl:value-of select="htd4:TransferType"/></td>
			<td colspan="1"><xsl:value-of select="htd4:NumSigRequired"/></td>
			<td colspan="7"><xsl:value-of select="htd4:Description"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="htd4:Permission">
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<td colspan="1"><xsl:value-of select="htd4:OrderTypes"/></td>
			<td colspan="1"><xsl:value-of select="@AuthorisationLevel"/></td>
			<td colspan="5"><xsl:value-of select="htd4:AccountID"/></td>
			<td colspan="1"><xsl:value-of select="htd4:MaxAmount/@AuthorisationLevel"/></td>
			<td colspan="1" align="right"><xsl:value-of select="htd4:MaxAmount"/></td>
		</tr>
	</xsl:template>

</xsl:stylesheet>
