﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!--
		Alle nicht abgehandelten Nodes landen hier und es passiert damit nichts
	-->
	<xsl:template match="*">
	</xsl:template>
	
	<xsl:template match="/OASResponse">
		<html>
			<head>
			<xsl:call-template name="glometa"/>
			</head>
			<BODY class="main">
				<xsl:apply-templates select="FileName"/>
				<table width="100%" cellspacing="0">
					<xsl:apply-templates select="Batch"/>
					<tr>
						<td><xsl:text> </xsl:text></td>
					</tr>
					<tr>
						<th class="dark" colspan="7">Dateiende</th>
					</tr>
				</table>
				<xsl:apply-templates select="Error"/>
				<xsl:text>
				</xsl:text>
			</BODY>
		</html>
	</xsl:template>

	<!--
		Summen ausgeben im Header aller Layouts
	-->
	<xsl:template match="Summary" mode="header">
		<tr>
			<xsl:if test="CreationDate!=''">
				<th class="light right" align="right" width="25%">Datei erstellt am</th>
			</xsl:if>
			<th class="light right" align="right" width="25%">Anzahl logischer Dateien</th>
			<th class="light right" align="right" width="25%">Gesamtanzahl Zahlungen<xsl:text> </xsl:text></th>
			<xsl:if test="Amount">
				<th class="light right" align="right" width="20%">Summe Zahlungen<xsl:text> </xsl:text></th>
				<th class="light right" align="right" width="5%">Währung</th>
			</xsl:if>
		</tr>
		<tr>
			<xsl:if test="CreationDate!=''">
				<td class="light right" align="right"><xsl:value-of select="CreationDate"/></td>
			</xsl:if>
			<td class="light right" align="right"><xsl:value-of select="Batch"/></td>
			<td class="light right" align="right"><xsl:value-of select="Payment"/><xsl:text> </xsl:text></td>
			<xsl:if test="Amount">
				<td class="light right" align="right"><xsl:value-of select="Amount"/><xsl:text> </xsl:text></td>
				<td class="light right" align="right"><xsl:value-of select="Curr"/></td>
			</xsl:if>
		</tr>
		<tr>
			<td align="left" class="light" colspan="5"></td>
		</tr>
		<tr>
			<td align="left" class="light" colspan="5"></td>
		</tr>
	</xsl:template>

	<!--
		Summen ausgeben je Batch
	-->
	<xsl:template match="Summary" mode="Batch">
	<!--
		<tr>
			<td class="light" align="left"><xsl:text> </xsl:text></td>
			<td class="light" align="left"><xsl:text> </xsl:text></td>
			<td class="light" align="left"><xsl:text> </xsl:text></td>
			<td class="light" align="right"><xsl:value-of select="Payment"/><xsl:text> </xsl:text></td>
			<td class="light" align="left"><xsl:value-of select="Curr"/></td>
			<td class="light" align="right"><xsl:value-of select="Amount"/><xsl:text> </xsl:text></td>
		</tr>
	-->
		<xsl:apply-templates select="Group"/>
	</xsl:template>

	<xsl:template match="Group">
		<tr>
			<td align="left" class="light">
				<xsl:call-template name="glotype"/>
			</td>
			<td align="left" class="light"><xsl:value-of select="Valuta"/></td>
			<td align="left" class="light">
				<xsl:value-of select="Bank"/><xsl:text> / </xsl:text><xsl:value-of select="Account"/><br></br>
				<xsl:value-of select="Ord"/>
			</td>
			<td align="right" class="light right"><xsl:value-of select="Payment"/></td>
			<td align="right" class="light right"><xsl:value-of select="Amount"/><xsl:text> </xsl:text></td>
			<td align="right" class="light right"><xsl:value-of select="Curr"/><xsl:text> </xsl:text></td>
		</tr>
	</xsl:template>
	
	<xsl:template name="SortIcons">
		<xsl:param name="SortNo"/>
		<xsl:param name="Name"/>
		<xsl:element name="img">
			<xsl:attribute name="src"><xsl:value-of select="/OASResponse/Base"/>\dat\sortdown.gif</xsl:attribute>
			<xsl:attribute name="onclick">Sort('<xsl:value-of select="$SortNo"/>','<xsl:value-of select="$Name"/>',1);</xsl:attribute>
		</xsl:element>
		<xsl:element name="img">
			<xsl:attribute name="src"><xsl:value-of select="/OASResponse/Base"/>\dat\sortup.gif</xsl:attribute>
			<xsl:attribute name="onclick">Sort('<xsl:value-of select="$SortNo"/>','<xsl:value-of select="$Name"/>',2);</xsl:attribute>
		</xsl:element>
		<br></br>
	</xsl:template>
	
	<xsl:template match="Batch">
		<xsl:variable name="SortNo"><xsl:value-of select="position()"/></xsl:variable>
		<tr>
			<td><xsl:text> </xsl:text></td>
		</tr>
		<tr>
			<th class="dark" colspan="7">Zahlungseinzelübersicht</th>
		</tr>
		<xsl:call-template name="gloline"/>
		<xsl:element name="tr">
		
			<xsl:attribute name="id"><xsl:value-of select="$SortNo"/></xsl:attribute>
				<xsl:variable name="SizeBen">
					<xsl:choose>
						<xsl:when test="Type[@mode] and Valuta and Ord/Account">32</xsl:when>
						<xsl:when test="Type[@mode] and Valuta">26</xsl:when>
						<xsl:when test="Type[@mode] and Ord/Account">29</xsl:when>
						<xsl:when test="Valuta and Ord/Account">29</xsl:when>
						<xsl:when test="Type[@mode]">23</xsl:when>
						<xsl:when test="Valuta">23</xsl:when>
						<xsl:when test="Ord/Account">26</xsl:when>
						<xsl:otherwise>20</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="SizeDetails">
					<xsl:choose>
						<xsl:when test="Type[@mode] and Valuta and Ord/Account">36</xsl:when>
						<xsl:when test="Type[@mode] and Valuta">28</xsl:when>
						<xsl:when test="Type[@mode] and Ord/Account">32</xsl:when>
						<xsl:when test="Valuta and Ord/Account">32</xsl:when>
						<xsl:when test="Type[@mode]">24</xsl:when>
						<xsl:when test="Valuta">24</xsl:when>
						<xsl:when test="Ord/Account">28</xsl:when>
						<xsl:otherwise>20</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="SizeAmount">
					<xsl:choose>
						<xsl:when test="Type[@mode] and Valuta and Ord/Account">27</xsl:when>
						<xsl:when test="Type[@mode] and Valuta">21</xsl:when>
						<xsl:when test="Type[@mode] and Ord/Account">24</xsl:when>
						<xsl:when test="Valuta and Ord/Account">24</xsl:when>
						<xsl:when test="Type[@mode]">18</xsl:when>
						<xsl:when test="Valuta">18</xsl:when>
						<xsl:when test="Ord/Account">21</xsl:when>
						<xsl:otherwise>15</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:if test="not(Type[@mode])">
					<th align="left"  class="light" width="10%"><xsl:text> </xsl:text>
						<xsl:element name="img">
							<xsl:attribute name="src"><xsl:value-of select="/OASResponse/Base"/>\dat\sortbutt.gif</xsl:attribute>
							<xsl:attribute name="onclick">Flip('<xsl:value-of select="$SortNo"/>');</xsl:attribute>
						</xsl:element>
					Typ</th>
				</xsl:if>

				<xsl:if test="not(Valuta)">
					<th align="left"  class="light" width="10%">
					<xsl:if test="Type[@mode]">
						<xsl:element name="img">
							<xsl:attribute name="src"><xsl:value-of select="/OASResponse/Base"/>\dat\sortbutt.gif</xsl:attribute>
							<xsl:attribute name="onclick">Flip('<xsl:value-of select="$SortNo"/>');</xsl:attribute>
						</xsl:element>
					</xsl:if>
					<xsl:call-template name="SortIcons">
						<xsl:with-param name="SortNo" select="$SortNo"/>
						<xsl:with-param name="Name">valuta</xsl:with-param>
					</xsl:call-template>
					Valuta</th>
				</xsl:if>

				<xsl:element name="th">
					<xsl:attribute name="align">left</xsl:attribute>
					<xsl:attribute name="class">light</xsl:attribute>
					<xsl:attribute name="width"><xsl:value-of select="$SizeBen"/>%</xsl:attribute>
					<xsl:if test="Type[@mode] and Valuta">
						<xsl:element name="img">
							<xsl:attribute name="src"><xsl:value-of select="/OASResponse/Base"/>\dat\sortbutt.gif</xsl:attribute>
							<xsl:attribute name="onclick">Flip('<xsl:value-of select="$SortNo"/>');</xsl:attribute>
						</xsl:element>
					</xsl:if>
					<xsl:call-template name="SortIcons">
						<xsl:with-param name="SortNo" select="$SortNo"/>
						<xsl:with-param name="Name">partner</xsl:with-param>
					</xsl:call-template>
					Partner
				</xsl:element>

				<xsl:if test="not(Ord/Account)">
					<th align="left"  class="light" width="20%">Auftraggeber</th>
				</xsl:if>

				<xsl:element name="th">
					<xsl:attribute name="align">left</xsl:attribute>
					<xsl:attribute name="class">light</xsl:attribute>
					<xsl:attribute name="width"><xsl:value-of select="$SizeDetails"/>%</xsl:attribute>
					<xsl:element name="input">
						<xsl:attribute name="name">Searchdetails<xsl:value-of select="$SortNo"/></xsl:attribute>
						<xsl:attribute name="id">Searchdetails<xsl:value-of select="$SortNo"/></xsl:attribute>
						<xsl:attribute name="onBlur">SearchDetails('<xsl:value-of select="$SortNo"/>');</xsl:attribute>
					</xsl:element>
					<xsl:call-template name="SortIcons">
						<xsl:with-param name="SortNo" select="$SortNo"/>
						<xsl:with-param name="Name">details</xsl:with-param>
					</xsl:call-template>
					Verwendungszweck
				</xsl:element>

				<xsl:element name="th">
					<xsl:attribute name="align">right</xsl:attribute>
					<xsl:attribute name="class">light right</xsl:attribute>
					<xsl:attribute name="width"><xsl:value-of select="$SizeAmount"/>%</xsl:attribute>
					
					<xsl:element name="select">
						<xsl:attribute name="name">SearchamountOp<xsl:value-of select="$SortNo"/></xsl:attribute>
						<xsl:attribute name="id">SearchamountOp<xsl:value-of select="$SortNo"/></xsl:attribute>
						<xsl:attribute name="onChange">SearchDetails('<xsl:value-of select="$SortNo"/>');</xsl:attribute>
						<option value="0">==</option>
						<option value="1">&gt;=</option>
						<option value="2">&lt;=</option>
						<option value="3">&gt;</option>
						<option value="4">&lt;</option>
					</xsl:element>

					<xsl:element name="input">
						<xsl:attribute name="size">8</xsl:attribute>
						<xsl:attribute name="name">Searchamount<xsl:value-of select="$SortNo"/></xsl:attribute>
						<xsl:attribute name="id">Searchamount<xsl:value-of select="$SortNo"/></xsl:attribute>
						<xsl:attribute name="onBlur">SearchDetails('<xsl:value-of select="$SortNo"/>');</xsl:attribute>
					</xsl:element>
					
					<xsl:call-template name="SortIcons">
						<xsl:with-param name="SortNo" select="$SortNo"/>
						<xsl:with-param name="Name">amount</xsl:with-param>
					</xsl:call-template>
					Betrag<xsl:text> </xsl:text>
				</xsl:element>

				<th align="left"  class="light right" width="5%">Währung</th>

		</xsl:element>
		<xsl:apply-templates select="Payment">
			<xsl:with-param name="SortNo" select="$SortNo"/>
		</xsl:apply-templates>
		<xsl:call-template name="logsummen"/>
	</xsl:template>

	<xsl:template name="BatchHeaderLine">
		<tr>
				<xsl:if test="not(Type[@mode])">
					<th align="left"  class="light" width="10%"><xsl:text> </xsl:text>
					Typ</th>
				</xsl:if>
				<xsl:if test="not(Valuta)">
					<th align="left"  class="light" width="10%">
					Valuta</th>
				</xsl:if>
				<th align="left" class="light">Partner</th>
				<xsl:if test="not(Ord/Account)">
					<th align="left"  class="light" width="20%">Auftraggeber</th>
				</xsl:if>
				<th align="left" class="light">Verwendungszweck</th>
				<th align="right" class="light right">Betrag<xsl:text> </xsl:text></th>
				<th align="left"  class="light right" width="5%">Währung</th>
		</tr>
	</xsl:template>

	<xsl:template name="logsummen">
		<tr>
			<th class="dark" colspan="7">Summeninformationen der logischen Datei</th>
		</tr>
    	<tr>
			<td colspan="10">
				<table width="100%" cellspacing="0">
					<tr>
						<th align="left" class="light" width="10%">Typ</th>
						<th align="left" class="light" width="10%">Valuta</th>
						<th align="left" class="light" width="20%">Auftraggeber</th>
						<th align="right" class="light right" width="28%">Gesamtanzahl Zahlungen</th>
						<th align="right" class="light right" width="27%">Summe Zahlungen</th>
						<th align="right" class="light right" width="5%">Währung</th>
					</tr>
					<xsl:apply-templates select="Summary" mode="Batch"/>
				</table>
			</td>
		</tr>
		<tr>
			<th class="dark" colspan="7">Ende einer logischen Datei</th>
		</tr>
		<tr><td><br></br></td></tr>
	</xsl:template>

	<xsl:template match="FileName">
		<xsl:variable name="ColumnCount" select="count(../Summary/Amount)*2+3"/>
		<table width="100%" cellspacing="0">
			<tr>
				<xsl:element name="th">
					<xsl:attribute name="class">dark</xsl:attribute>
					<xsl:attribute name="colspan"><xsl:value-of select="$ColumnCount"/></xsl:attribute>
					Allgemeine Informationen zur Datei <xsl:value-of select="."/>
				</xsl:element>
			</tr>
			<xsl:text>
			</xsl:text>
			<xsl:apply-templates select="../Summary" mode="header"/>
		</table>
	</xsl:template>

	<xsl:template name="glotype">
		<xsl:choose>
			<xsl:when test="Type[@mode='TRANSFER' and @precedence='URGENT']">Eilüberweisung</xsl:when>
			<xsl:when test="Type[@mode='TRANSFER' and @precedence!='URGENT']">Überweisung</xsl:when>
			<xsl:when test="Type[@mode='TRANSFER']">Überweisung</xsl:when>
			<xsl:when test="Type[@mode='DEBIT']">Lastschrift</xsl:when>
			<xsl:when test="Type[@mode='CHEQUE']">Scheck</xsl:when>
			<xsl:when test="Type[@mode='OTHER']">Sonstiges</xsl:when>
		</xsl:choose>
		<xsl:if test="Type!=''">
			<xsl:text> (</xsl:text>
			<xsl:value-of select="Type"/>
			<xsl:text>)</xsl:text>
		</xsl:if>
	</xsl:template>
	
	<!--
		Header pro Batch mit Infos aus dem Batchlevel
	-->
	<xsl:template name="gloline">
		<xsl:if test="Ref | Type[@mode] | Valuta | Ord/Account">
			<tr>
			<td colspan="7">
			<table width="100%" cellspacing="0">
				<tr>
					<xsl:if test="Type[@mode]">
						<th align="left"  class="light" width="20%"><xsl:text> </xsl:text>Typ</th>
					</xsl:if>
					<xsl:if test="Valuta">
						<th align="left"  class="light" width="20%">Valuta</th>
					</xsl:if>
					<xsl:if test="Ord/Account">
						<th align="left"  class="light" width="40%">Auftraggeber / Partner</th>
					</xsl:if>
					<xsl:if test="Ref">
						<th align="left"  class="light" width="20%">Referenz</th>
					</xsl:if>
					<th align="left"  class="light" colspan="6"><xsl:text> </xsl:text></th>
				</tr>
				<tr>
					<xsl:if test="Type[@mode]">
						<td align="left"  class="light">
							<xsl:call-template name="glotype"/>
						</td>
					</xsl:if>
					<xsl:if test="Valuta">
						<td align="left"  class="light"><xsl:value-of select="Valuta"/></td>
					</xsl:if>
					<xsl:if test="Ord/Account">
						<td align="left"  class="light"><xsl:value-of select="Ord/Bank/Code"/><xsl:text> / </xsl:text><xsl:value-of select="Ord/Account"/></td>
					</xsl:if>
					<xsl:if test="Ref">
						<td align="left"  class="light"><xsl:value-of select="Ref"/></td>
					</xsl:if>
					<td align="left"  class="light" colspan="6"><xsl:text> </xsl:text></td>
				</tr>
				<xsl:if test="Ord/Account">
					<xsl:if test="Ord/Adress/Name[@Rel='0']">
						<tr>
							<xsl:if test="Type[@mode]">
								<td align="left"  class="light"><xsl:text> </xsl:text></td>
							</xsl:if>
							<xsl:if test="Valuta">
								<td align="left"  class="light"><xsl:text> </xsl:text></td>
							</xsl:if>
							<td align="left"  class="light"><xsl:value-of disable-output-escaping="yes" select="Ord/Adress/Name[@Rel='0']"/></td>
							<td align="left"  class="light" colspan="6"><xsl:text> </xsl:text></td>
						</tr>
					</xsl:if>
				</xsl:if>
			</table>
			</td>
			</tr>
		</xsl:if>
	</xsl:template>

	<!--
		Globale Eintragungen in den Header der Seite
	-->
	<xsl:template name="glometa">
		<xsl:element name="META">
			<xsl:attribute name="http-equiv">Content-Type</xsl:attribute>
			<xsl:attribute name="content">text/html; charset=UTF-8</xsl:attribute>
		</xsl:element><xsl:text>
</xsl:text>
		<xsl:choose>
			<xsl:when test="$DownloadBase">
				<xsl:element name="link">
					<xsl:attribute name="rel">stylesheet</xsl:attribute>
					<xsl:attribute name="type">text/css</xsl:attribute>
					<xsl:attribute name="href"><xsl:value-of select="$DownloadBase"></xsl:value-of>/omikron.css</xsl:attribute>
				</xsl:element><xsl:text>
</xsl:text>
				<xsl:element name="link">
					<xsl:attribute name="rel">stylesheet</xsl:attribute>
					<xsl:attribute name="type">text/css</xsl:attribute>
					<xsl:attribute name="href"><xsl:value-of select="$DownloadBase"></xsl:value-of>/payment.css</xsl:attribute>
				</xsl:element><xsl:text>
</xsl:text>
				<xsl:element name="SCRIPT">
					<xsl:attribute name="LANGUAGE">JavaScript</xsl:attribute>
					<xsl:attribute name="SRC"><xsl:value-of select="$DownloadBase"></xsl:value-of>/sort.js</xsl:attribute>
				</xsl:element><xsl:text>
</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="Base" select="Base"></xsl:variable>
				<xsl:element name="link">
					<xsl:attribute name="rel">stylesheet</xsl:attribute>
					<xsl:attribute name="type">text/css</xsl:attribute>
					<xsl:attribute name="href"><xsl:value-of select="$Base"></xsl:value-of>\dat\omikron.css</xsl:attribute>
				</xsl:element><xsl:text>
</xsl:text>
				<xsl:element name="SCRIPT">
					<xsl:attribute name="LANGUAGE">JavaScript</xsl:attribute>
					<xsl:attribute name="SRC"><xsl:value-of select="$Base"></xsl:value-of>\dat\sort.js</xsl:attribute>
				</xsl:element><xsl:text>
</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--
		Ausgabe der Fehler zu einer Datei
	-->
	<xsl:template match="Error">
		<xsl:if test="position()=1">
			<xsl:text disable-output-escaping="yes">&lt;table width="100%" cellspacing="0"&gt;
			</xsl:text>
			<tr>
				<th class="dark">Die Datei enthält die folgenden Fehler</th>
			</tr>
		</xsl:if>
		<tr>
			<td align="left" class="light">
				<xsl:value-of disable-output-escaping="yes" select="Text"/>
			</td>
		</tr>
		<xsl:if test="position()=last()">
			<xsl:text disable-output-escaping="no">&lt;/table&gt;</xsl:text>
		</xsl:if>
	</xsl:template>

	<xsl:template name="PaymentSingle">
		<xsl:param name="SortNo"/>
		<xsl:element name="tr">
			<xsl:attribute name="id"><xsl:value-of select="$SortNo"/></xsl:attribute>
			<xsl:if test="not(../Type[@mode])">
				<td align="left"  class="light">
					<xsl:call-template name="glotype"/>
				</td>
			</xsl:if>
			<xsl:if test="not(../Valuta)">
				<td align="left"  class="light" id="valuta"><xsl:value-of select="Valuta"/></td>
			</xsl:if>
			<td align="left"  class="light" id="partner">
				<xsl:value-of disable-output-escaping="yes" select="Ben/Adress/Name[@Rel='0']"/>
				<xsl:text> / </xsl:text>
				<xsl:value-of select="Ben/Bank/Code"/>
				<xsl:text> / </xsl:text>
				<xsl:value-of select="Ben/Account"/>
			</td>
			<xsl:if test="not(../Ord/Account)">
				<td align="left"  class="light"><xsl:value-of select="Ord/Bank/Code"/><xsl:text> / </xsl:text><xsl:value-of select="Ord/Account"/></td>
			</xsl:if>
			<td align="left"  class="light" id="details"><xsl:value-of disable-output-escaping="yes" select="Details[@Rel='0']"/></td>
			<td align="right" class="light right" id="amount"><xsl:value-of select="Amount"/><xsl:text> </xsl:text></td>
			<td align="left" class="light right"><xsl:value-of select="Curr"/><xsl:text> </xsl:text></td>
		</xsl:element>
	</xsl:template>

	<xsl:template name="PaymentDouble">
		<xsl:param name="SortNo"/>
		<xsl:element name="tr">
			<xsl:attribute name="id"><xsl:value-of select="$SortNo"/></xsl:attribute>
			<xsl:if test="not(../Type[@mode])">
				<td align="left"  class="light">
					<xsl:call-template name="glotype"/>
				</td>
			</xsl:if>
			<xsl:if test="not(../Valuta)">
				<td align="left"  class="light" id="valuta"><xsl:value-of select="Valuta"/></td>
			</xsl:if>
			<td align="left"  class="light" id="partner"><xsl:value-of select="Ben/Bank/Code"/><xsl:text> / </xsl:text><xsl:value-of select="Ben/Account"/><br>
			<xsl:value-of disable-output-escaping="yes" select="Ben/Adress/Name[@Rel='0']"/></br></td>
			<xsl:if test="not(../Ord/Account)">
				<td align="left"  class="light"><xsl:value-of select="Ord/Bank/Code"/><xsl:text> / </xsl:text><xsl:value-of select="Ord/Account"/><br>
				<xsl:value-of disable-output-escaping="yes" select="Ord/Adress/Name[@Rel='0']"/></br></td>
			</xsl:if>
			<td align="left"  class="light" id="details"><xsl:value-of disable-output-escaping="yes" select="Details[@Rel='0']"/><br>
			<xsl:value-of disable-output-escaping="yes" select="Details[@Rel='1']"/></br></td>
			<td align="right" class="light right" id="amount"><xsl:value-of select="Amount"/><xsl:text> </xsl:text></td>
			<td align="left" class="light right"><xsl:value-of select="Curr"/><xsl:text> </xsl:text></td>
		</xsl:element>
	</xsl:template>

	<xsl:template name="PaymentComplete">
		<tr>
			<xsl:if test="not(../Type[@mode])">
				<th align="left"  class="light" width="10%"><xsl:text> </xsl:text>Typ</th>
			</xsl:if>
			<xsl:if test="not(../Valuta)">
				<th align="left"  class="light" width="10%">Valuta</th>
			</xsl:if>
			<th align="left" class="light" width="30%">Partner<xsl:text> </xsl:text>Bank/Konto/Name</th>
			<th align="left" class="light" width="30%">Auftraggeber<xsl:text> </xsl:text>Bank/Konto/Name/ Verwendungszweck</th>
			<th align="right" class="light right" width="15%">Betrag<xsl:text> </xsl:text></th>
			<th align="left" class="light right" width="5%">Währung</th>
		</tr>
		<tr>
			<xsl:if test="not(../Type[@mode])">
				<td align="left" class="light">
					<xsl:call-template name="glotype"/>
				</td>
			</xsl:if>
			<xsl:if test="not(../Valuta)">
				<td align="left" class="light"><xsl:value-of select="Valuta"/></td>
			</xsl:if>
			<td align="left" class="light"><xsl:value-of select="Ben/Bank/Code"/><xsl:text> / </xsl:text><xsl:value-of select="Ben/Account"/></td>
			<xsl:choose>
				<xsl:when test="../Ord/Account">
					<td align="left" class="light"><xsl:value-of select="../Ord/Bank/Code"/><xsl:text> / </xsl:text><xsl:value-of select="../Ord/Account"/></td>
				</xsl:when>
				<xsl:otherwise>
					<td align="left" class="light"><xsl:value-of select="Ord/Bank/Code"/><xsl:text> / </xsl:text><xsl:value-of select="Ord/Account"/></td>
				</xsl:otherwise>
			</xsl:choose>
			<td align="right" class="light right"><xsl:value-of select="Amount"/><xsl:text> </xsl:text></td>
			<td align="left" class="light right"><xsl:value-of select="Curr"/><xsl:text> </xsl:text></td>
		</tr>

		<!--
			Ein paar globale Werte suchen
		-->
		<xsl:variable name="OrdName0">
			<xsl:choose>
				<xsl:when test="../Ord/Adress/Name[@Rel='0']"><xsl:value-of select="../Ord/Adress/Name[@Rel='0']"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="Ord/Adress/Name[@Rel='0']"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="OrdName1">
			<xsl:choose>
				<xsl:when test="../Ord/Adress/Name[@Rel='1']"><xsl:value-of select="../Ord/Adress/Name[@Rel='1']"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="Ord/Adress/Name[@Rel='1']"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="OrdPerson">
			<xsl:choose>
				<xsl:when test="../Ord/Adress/ContactPerson"><xsl:value-of select="../Ord/Adress/ContactPerson"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="Ord/Adress/ContactPerson"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="OrdStreet">
			<xsl:choose>
				<xsl:when test="../Ord/Adress/Street"><xsl:value-of select="../Ord/Adress/Street"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="Ord/Adress/Street"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="OrdTown">
			<xsl:choose>
				<xsl:when test="../Ord/Adress/Town"><xsl:value-of select="../Ord/Adress/Town"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="Ord/Adress/Town"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="OrdPostCode">
			<xsl:choose>
				<xsl:when test="../Ord/Adress/PostCode"><xsl:value-of select="../Ord/Adress/PostCode"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="Ord/Adress/PostCode"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="OrdCountry">
			<xsl:choose>
				<xsl:when test="../Ord/Adress/Country"><xsl:value-of select="../Ord/Adress/Country"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="Ord/Adress/Country"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:call-template name="comline">
			<xsl:with-param name="P1" select="Ben/Adress/Name[@Rel='0']"/>
			<xsl:with-param name="P2" select="$OrdName0"/>
		</xsl:call-template>
		<xsl:if test="Ben/Adress/Name[@Rel='1'] or $OrdName1">
			<xsl:call-template name="comline">
				<xsl:with-param name="P1" select="Ben/Adress/Name[@Rel='1']"/>
				<xsl:with-param name="P2" select="$OrdName1"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="Ben/Adress/ContactPerson or $OrdPerson">
			<xsl:call-template name="comline">
				<xsl:with-param name="P1" select="Ben/Adress/ContactPerson"/>
				<xsl:with-param name="P2" select="$OrdPerson"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="Ben/Adress/Street or $OrdStreet">
			<xsl:call-template name="comline">
				<xsl:with-param name="P1" select="Ben/Adress/Street"/>
				<xsl:with-param name="P2" select="$OrdStreet"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="Ben/Adress/Town or $OrdTown">
			<xsl:call-template name="comline">
				<xsl:with-param name="P1">
					<xsl:value-of select="Ben/Adress/Country"/><xsl:text> </xsl:text>
					<xsl:value-of select="Ben/Adress/PostCode"/><xsl:text> </xsl:text>
					<xsl:value-of select="Ben/Adress/Town"/>
				</xsl:with-param>
				<xsl:with-param name="P2">
					<xsl:value-of select="$OrdCountry"/><xsl:text> </xsl:text>
					<xsl:value-of select="$OrdPostCode"/><xsl:text> </xsl:text>
					<xsl:value-of select="$OrdTown"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:call-template name="AdditionalOrd"/>

		<xsl:if test="Ref">
			<tr>
				<xsl:if test="not(../Type[@mode])">
					<td align="left" class="light"><xsl:text> </xsl:text></td>
				</xsl:if>
				<xsl:if test="not(../Valuta)">
					<td align="left" class="light"><xsl:text> </xsl:text></td>
				</xsl:if>
				<td align="left" class="light"><xsl:text> </xsl:text></td>
				<td align="left" class="light"><xsl:text> </xsl:text></td>
				<td align="left" class="light"><xsl:text> </xsl:text></td>
				<td align="left" class="light"><b><xsl:text>Referenz</xsl:text></b></td>
			</tr>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="not(Details) and Ref">
				<tr>
					<xsl:if test="not(../Type[@mode])">
						<td align="left" class="light"><xsl:text> </xsl:text></td>
					</xsl:if>
					<xsl:if test="not(../Valuta)">
						<td align="left" class="light"><xsl:text> </xsl:text></td>
					</xsl:if>
					<td align="left" class="light" colspan="3"><xsl:text> </xsl:text></td>
					<td align="left" class="light">
						<xsl:value-of select="Ref"/>
						<xsl:text> </xsl:text>
					</td>
				</tr>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="Details">
					<xsl:choose>
						<xsl:when test="@Rel='0'">
							<tr>
								<xsl:if test="not(../../Type[@mode])">
									<td align="left"  class="light"><xsl:text> </xsl:text></td>
								</xsl:if>
								<xsl:if test="not(../../Valuta)">
									<td align="left"  class="light"><xsl:text> </xsl:text></td>
								</xsl:if>
								<td align="left"  class="light"><xsl:text> </xsl:text></td>
								<td align="left"  class="light"><xsl:value-of disable-output-escaping="yes" select="."/></td>
								<td align="left" class="light"><xsl:text> </xsl:text></td>
								<td align="left" class="light">						
									<xsl:choose>
										<xsl:when test="../Ref"><xsl:value-of select="../Ref"/></xsl:when>
										<xsl:otherwise><xsl:text> </xsl:text></xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="comline2">
								<xsl:with-param name="P1"> </xsl:with-param>
								<xsl:with-param name="P2" select="."/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="AdditionalOrd"/>

	<xsl:template name="comline">
		<xsl:param name="P1"/>
		<xsl:param name="P2"/>
		<tr>
			<xsl:if test="not(../Type[@mode])">
				<td align="left"  class="light"><xsl:text> </xsl:text></td>
			</xsl:if>
			<xsl:if test="not(../Valuta)">
				<td align="left"  class="light"><xsl:text> </xsl:text></td>
			</xsl:if>
			<td align="left"  class="light"><xsl:value-of disable-output-escaping="yes" select="$P1"/></td>
			<td align="left"  class="light"><xsl:value-of disable-output-escaping="yes" select="$P2"/></td>
			<td align="left" class="light"><xsl:text> </xsl:text></td>
			<td align="right" class="light right"><xsl:text> </xsl:text></td>
		</tr>
	</xsl:template>

	<xsl:template name="comline2">
		<xsl:param name="P1"/>
		<xsl:param name="P2"/>
		<tr>
			<xsl:if test="not(../../Type[@mode])">
				<td align="left"  class="light"><xsl:text> </xsl:text></td>
			</xsl:if>
			<xsl:if test="not(../../Valuta)">
				<td align="left"  class="light"><xsl:text> </xsl:text></td>
			</xsl:if>
			<td align="left" class="light"><xsl:value-of disable-output-escaping="yes" select="$P1"/></td>
			<td align="left" class="light"><xsl:value-of disable-output-escaping="yes" select="$P2"/></td>
			<td align="left" class="light"><xsl:text> </xsl:text></td>
			<td align="right" class="light right"><xsl:text> </xsl:text></td>
		</tr>
	</xsl:template>

	<xsl:template name="FirstTwoColumns">
		<xsl:if test="not(../Type[@mode])">
			<td align="left"  class="light"><xsl:text> </xsl:text></td>
		</xsl:if>
		<xsl:if test="not(../Valuta)">
			<td align="left"  class="light"><xsl:text> </xsl:text></td>
		</xsl:if>
	</xsl:template>

	<xsl:template name="gloheaderComplete">
		<tr>
			<td><xsl:text> </xsl:text></td>
		</tr>
		<tr>
			<th class="dark" colspan="7">Zahlungseinzelübersicht</th>
		</tr>
	</xsl:template>

</xsl:stylesheet>
