﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:hkd4="urn:org:ebics:H004" xmlns:hkd="http://www.ebics.org/H003" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" encoding="UTF-8" omit-xml-declaration="yes"/>
	<xsl:param name="DownloadBase"></xsl:param>
	<xsl:param name="BankName"></xsl:param>

	<!--
		Alle nicht abgehandelten Nodes landen hier und es passiert damit nichts
	-->
	<xsl:template match="*">
	</xsl:template>


	<xsl:template match="hkd:HKDResponseOrderData">
		<html>
			<head>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">..\dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">..\..\dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="META">
				<xsl:attribute name="http-equiv">Content-Type</xsl:attribute>
				<xsl:attribute name="content">text/html; charset=UTF-8</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			</head>
			<BODY class="main">
				<table width="100%" cellspacing="0">
				<tr>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
				</tr>
				<tr><th colspan="10"><h2><xsl:value-of select="$BankName"></xsl:value-of></h2></th></tr>
				<xsl:apply-templates select="hkd:PartnerInfo"/>
				<xsl:apply-templates select="hkd:UserInfo"/>
				</table>
			</BODY>
		</html>
	</xsl:template>

	<xsl:template match="hkd:PartnerInfo">
		<xsl:apply-templates select="hkd:AddressInfo"/>
		<xsl:apply-templates select="hkd:BankInfo"/>
		<xsl:if test="hkd:AccountInfo">
			<xsl:call-template name="Header2">
				<xsl:with-param name="Label">Account data</xsl:with-param>
			</xsl:call-template>
			<tr>
				<th class="light" align="left" colspan="1"><h4>Currency</h4></th>
				<th class="light" align="left"  colspan="3"><h4>Account id</h4></th>
				<th class="light" align="left"  colspan="2"><h4>Bank</h4></th>
				<th class="light" align="left"  colspan="4"><h4>A/c. number</h4></th>
			</tr>
			<xsl:apply-templates select="hkd:AccountInfo"/>
		</xsl:if>
		<xsl:if test="hkd:OrderInfo">
			<xsl:call-template name="Header2">
				<xsl:with-param name="Label">Session types</xsl:with-param>
			</xsl:call-template>
			<tr>
				<th class="light" align="left" colspan="1"><h4>Session type</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Direction</h4></th>
				<th class="light" align="left"  colspan="1"><h4>ES required</h4></th>
				<th class="light" align="left"  colspan="7"><h4>Description</h4></th>
			</tr>
			<xsl:apply-templates select="hkd:OrderInfo"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="hkd:UserInfo">
		<tr>
			<td colspan="10"><br/></td>
		</tr>
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">User</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="1"><h4>User</h4></th>
			<th class="light" align="left"  colspan="3"><h4>Name</h4></th>
			<th class="light" align="left"  colspan="6"><h4>Status</h4></th>
		</tr>
		<tr>
			<td colspan="1"><xsl:value-of select="hkd:UserID"/></td>
			<td colspan="3"><xsl:value-of select="hkd:Name"/></td>
			<td colspan="6">
				<xsl:if test="hkd:UserID/@Status=1">Ready</xsl:if>
				<xsl:if test="hkd:UserID/@Status=2">New</xsl:if>
				<xsl:if test="hkd:UserID/@Status=3">Partially initialized (INI)</xsl:if>
				<xsl:if test="hkd:UserID/@Status=4">Partially initialized (HIA)</xsl:if>
				<xsl:if test="hkd:UserID/@Status=5">Initialized</xsl:if>
				<xsl:if test="hkd:UserID/@Status=6">Blocked, repeated unsuccessful comms</xsl:if>
				<xsl:if test="hkd:UserID/@Status=7">New FTAM</xsl:if>
				<xsl:if test="hkd:UserID/@Status=8">Blocked, by user</xsl:if>
				<xsl:if test="hkd:UserID/@Status=9">Blocked, by bank</xsl:if>
			</td>
		</tr>
		<xsl:if test="hkd:Permission">
			<xsl:call-template name="Header3">
				<xsl:with-param name="Label">Authorization</xsl:with-param>
			</xsl:call-template>
			<tr>
				<td colspan="1"><xsl:text> </xsl:text></td>
				<th class="light" align="left" colspan="1"><h4>Session type</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Signature class</h4></th>
				<th class="light" align="left"  colspan="5"><h4>Account id</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Currency</h4></th>
				<th class="light" align="right"  colspan="1"><h4>Maximum amount</h4></th>
			</tr>
			<xsl:apply-templates select="hkd:Permission"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Header2">
		<xsl:param name="Label"/>
		<tr>
			<td colspan="10"><br/></td>
		</tr>
		<tr>
			<th class="dark" align="left" colspan="10"><xsl:value-of select="$Label"/>:</th>
		</tr>
	</xsl:template>

	<xsl:template name="Header3">
		<xsl:param name="Label"/>
		<tr>
			<td colspan="10"><br/></td>
		</tr>
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<th class="dark" align="left" colspan="9"><xsl:value-of select="$Label"/>:</th>
		</tr>
	</xsl:template>

	<xsl:template match="hkd:AddressInfo">
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Address</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="10"><h4>Name and address</h4></th>
		</tr>
		<tr>
			<td colspan="10">
				<xsl:value-of select="hkd:Name"/>
				<xsl:if test="hkd:Street">
					, <xsl:value-of select="hkd:Street"/>
				</xsl:if>
				<xsl:if test="hkd:PostCode">
					, <xsl:value-of select="hkd:Country"/> <xsl:value-of select="hkd:Region"/> <xsl:value-of select="hkd:PostCode"/> <xsl:value-of select="hkd:City"/>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="hkd:BankInfo">
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Information on bank</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="10"><h4>Host name</h4></th>
		</tr>
		<tr>
			<td colspan="10"><xsl:value-of select="hkd:HostID"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="hkd:AccountInfo">
		<tr>
			<td colspan="1"><xsl:value-of select="@Currency"/></td>
			<td colspan="3"><xsl:value-of select="@ID"/></td>
			<td colspan="2">
				<xsl:value-of select="hkd:BankCode"/>
				<xsl:if test="hkd:NationalBankCode">
					<br></br><xsl:value-of select="hkd:NationalBankCode"/>
				</xsl:if>
			</td>
			<td colspan="4">
				<xsl:value-of select="hkd:AccountNumber"/>
				<xsl:if test="hkd:NationalAccountNumber">
					<br></br><xsl:value-of select="hkd:NationalAccountNumber"/>
				</xsl:if>
			</td>
		</tr>
		<xsl:if test="hkd:UsageOrderTypes">
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<td colspan="2">Session types:</td>
			<td colspan="7"><xsl:value-of select="hkd:UsageOrderTypes"/></td>
		</tr>
		</xsl:if>
	</xsl:template>

	<xsl:template match="hkd:OrderInfo">
		<tr>
			<td colspan="1"><xsl:value-of select="hkd:OrderType"/></td>
			<td colspan="1"><xsl:value-of select="hkd:TransferType"/></td>
			<td colspan="1"><xsl:value-of select="hkd:NumSigRequired"/></td>
			<td colspan="7"><xsl:value-of select="hkd:Description"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="hkd:Permission">
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<td colspan="1"><xsl:value-of select="hkd:OrderTypes"/></td>
			<td colspan="1"><xsl:value-of select="@AuthorisationLevel"/></td>
			<td colspan="5"><xsl:value-of select="hkd:AccountID"/></td>
			<td colspan="1"><xsl:value-of select="hkd:MaxAmount/@AuthorisationLevel"/></td>
			<td colspan="1" align="right"><xsl:value-of select="hkd:MaxAmount"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="hkd4:HKDResponseOrderData">
		<html>
			<head>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">..\dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="link">
				<xsl:attribute name="rel">stylesheet</xsl:attribute>
				<xsl:attribute name="type">text/css</xsl:attribute>
				<xsl:attribute name="href">..\..\dat\omikron.css</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			<xsl:element name="META">
				<xsl:attribute name="http-equiv">Content-Type</xsl:attribute>
				<xsl:attribute name="content">text/html; charset=UTF-8</xsl:attribute>
			</xsl:element><xsl:text>&#32;
</xsl:text>
			</head>
			<BODY class="main">
				<table width="100%" cellspacing="0">
				<tr>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
					<td width="10%"></td>
				</tr>
				<tr><th colspan="10"><h2><xsl:value-of select="$BankName"></xsl:value-of></h2></th></tr>
				<xsl:apply-templates select="hkd4:PartnerInfo"/>
				<xsl:apply-templates select="hkd4:UserInfo"/>
				</table>
			</BODY>
		</html>
	</xsl:template>

	<xsl:template match="hkd4:PartnerInfo">
		<xsl:apply-templates select="hkd4:AddressInfo"/>
		<xsl:apply-templates select="hkd4:BankInfo"/>
		<xsl:if test="hkd4:AccountInfo">
			<xsl:call-template name="Header2">
				<xsl:with-param name="Label">Account data</xsl:with-param>
			</xsl:call-template>
			<tr>
				<th class="light" align="left" colspan="1"><h4>Currency</h4></th>
				<th class="light" align="left"  colspan="3"><h4>Account id</h4></th>
				<th class="light" align="left"  colspan="2"><h4>Bank</h4></th>
				<th class="light" align="left"  colspan="4"><h4>A/c. number</h4></th>
			</tr>
			<xsl:apply-templates select="hkd4:AccountInfo"/>
		</xsl:if>
		<xsl:if test="hkd4:OrderInfo">
			<xsl:call-template name="Header2">
				<xsl:with-param name="Label">Session types</xsl:with-param>
			</xsl:call-template>
			<tr>
				<th class="light" align="left" colspan="1"><h4>Session type</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Direction</h4></th>
				<th class="light" align="left"  colspan="1"><h4>ES required</h4></th>
				<th class="light" align="left"  colspan="7"><h4>Description</h4></th>
			</tr>
			<xsl:apply-templates select="hkd4:OrderInfo"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="hkd4:UserInfo">
		<tr>
			<td colspan="10"><br/></td>
		</tr>
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">User</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="1"><h4>User</h4></th>
			<th class="light" align="left"  colspan="3"><h4>Name</h4></th>
			<th class="light" align="left"  colspan="6"><h4>Status</h4></th>
		</tr>
		<tr>
			<td colspan="1"><xsl:value-of select="hkd4:UserID"/></td>
			<td colspan="3"><xsl:value-of select="hkd4:Name"/></td>
			<td colspan="6">
				<xsl:if test="hkd4:UserID/@Status=1">Ready</xsl:if>
				<xsl:if test="hkd4:UserID/@Status=2">New</xsl:if>
				<xsl:if test="hkd4:UserID/@Status=3">Partially initialized (INI)</xsl:if>
				<xsl:if test="hkd4:UserID/@Status=4">Partially initialized (HIA)</xsl:if>
				<xsl:if test="hkd4:UserID/@Status=5">Initialized</xsl:if>
				<xsl:if test="hkd4:UserID/@Status=6">Blocked, repeated unsuccessful comms</xsl:if>
				<xsl:if test="hkd4:UserID/@Status=7">New FTAM</xsl:if>
				<xsl:if test="hkd4:UserID/@Status=8">Blocked, by user</xsl:if>
				<xsl:if test="hkd4:UserID/@Status=9">Blocked, by bank</xsl:if>
			</td>
		</tr>
		<xsl:if test="hkd4:Permission">
			<xsl:call-template name="Header3">
				<xsl:with-param name="Label">Authorization</xsl:with-param>
			</xsl:call-template>
			<tr>
				<td colspan="1"><xsl:text> </xsl:text></td>
				<th class="light" align="left" colspan="1"><h4>Session type</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Signature class</h4></th>
				<th class="light" align="left"  colspan="5"><h4>Account id</h4></th>
				<th class="light" align="left"  colspan="1"><h4>Currency</h4></th>
				<th class="light" align="right"  colspan="1"><h4>Maximum amount</h4></th>
			</tr>
			<xsl:apply-templates select="hkd4:Permission"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="hkd4:AddressInfo">
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Address</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="10"><h4>Name and address</h4></th>
		</tr>
		<tr>
			<td colspan="10">
				<xsl:value-of select="hkd4:Name"/>
				<xsl:if test="hkd4:Street">
					, <xsl:value-of select="hkd4:Street"/>
				</xsl:if>
				<xsl:if test="hkd4:PostCode">
					, <xsl:value-of select="hkd4:Country"/> <xsl:value-of select="hkd4:Region"/> <xsl:value-of select="hkd4:PostCode"/> <xsl:value-of select="hkd4:City"/>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="hkd4:BankInfo">
		<xsl:call-template name="Header2">
			<xsl:with-param name="Label">Information on bank</xsl:with-param>
		</xsl:call-template>
		<tr>
			<th class="light" align="left" colspan="10"><h4>Host name</h4></th>
		</tr>
		<tr>
			<td colspan="10"><xsl:value-of select="hkd4:HostID"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="hkd4:AccountInfo">
		<tr>
			<td colspan="1"><xsl:value-of select="@Currency"/></td>
			<td colspan="3"><xsl:value-of select="@ID"/></td>
			<td colspan="2">
				<xsl:value-of select="hkd4:BankCode"/>
				<xsl:if test="hkd4:NationalBankCode">
					<br></br><xsl:value-of select="hkd4:NationalBankCode"/>
				</xsl:if>
			</td>
			<td colspan="4">
				<xsl:value-of select="hkd4:AccountNumber"/>
				<xsl:if test="hkd4:NationalAccountNumber">
					<br></br><xsl:value-of select="hkd4:NationalAccountNumber"/>
				</xsl:if>
			</td>
		</tr>
		<xsl:if test="hkd4:UsageOrderTypes">
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<td colspan="2">Session types:</td>
			<td colspan="7"><xsl:value-of select="hkd4:UsageOrderTypes"/></td>
		</tr>
		</xsl:if>
	</xsl:template>

	<xsl:template match="hkd4:OrderInfo">
		<tr>
			<td colspan="1"><xsl:value-of select="hkd4:OrderType"/></td>
			<td colspan="1"><xsl:value-of select="hkd4:TransferType"/></td>
			<td colspan="1"><xsl:value-of select="hkd4:NumSigRequired"/></td>
			<td colspan="7"><xsl:value-of select="hkd4:Description"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="hkd4:Permission">
		<tr>
			<td colspan="1"><xsl:text> </xsl:text></td>
			<td colspan="1"><xsl:value-of select="hkd4:OrderTypes"/></td>
			<td colspan="1"><xsl:value-of select="@AuthorisationLevel"/></td>
			<td colspan="5"><xsl:value-of select="hkd4:AccountID"/></td>
			<td colspan="1"><xsl:value-of select="hkd4:MaxAmount/@AuthorisationLevel"/></td>
			<td colspan="1" align="right"><xsl:value-of select="hkd4:MaxAmount"/></td>
		</tr>
	</xsl:template>

</xsl:stylesheet>
