﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" encoding="UTF-8" omit-xml-declaration="yes"/>
	<xsl:param name="DownloadBase"></xsl:param>
	<xsl:include href="glo.xsl"/>

	<xsl:template match="/OASResponse">
		<html>
			<head>
			<xsl:call-template name="glometa"/>
			</head>
			<BODY class="main">
				<xsl:apply-templates select="FileName"/>
				<xsl:apply-templates select="Summary" mode="detailed"/>
				<xsl:apply-templates select="Error"/>
				<xsl:text>
				</xsl:text>
			</BODY>
		</html>
	</xsl:template>

	<!--
		Summen ausgeben 
	-->
	<xsl:template match="Summary" mode="detailed">
		<table width="100%" cellspacing="0">
		<tr>
			<th class="dark" colspan="5">Summary information on all payments</th>
		</tr>
		<tr>
			<th align="left"  class="light" width="25%"><xsl:text> </xsl:text>Type</th>
			<th align="left"  class="light" width="25%">Value date<xsl:text> / </xsl:text>Ordering party</th>
			<th align="left"  class="light" width="20%">Number</th>
			<th align="right" class="light right" width="25%">Amount<xsl:text> </xsl:text></th>
			<th align="left"  class="light right" width="15%">Currency</th>
		</tr>
		<xsl:apply-templates select="Group"/>
		</table>
	</xsl:template>

	<!--
		Einzelne Gruppensumme ausgeben
	-->
	<xsl:template match="Group">
		<tr>
			<td align="left"  class="light">
				<xsl:call-template name="glotype"/>
			</td>
			<td align="left"  class="light"><xsl:value-of select="Valuta"/></td>
			<td align="left"  class="light"><xsl:value-of select="Payment"/></td>
			<td align="right" class="light right"><xsl:value-of select="Amount"/><xsl:text> </xsl:text></td>
			<td align="left" class="light right"><xsl:value-of select="Curr"/><xsl:text> </xsl:text></td>
		</tr>
		<tr>
			<td align="left"  class="light"><xsl:text> </xsl:text></td>
			<td align="left"  class="light"><xsl:value-of select="Bank"/></td>
			<td align="left"  class="light" colspan="2">
				<xsl:value-of select="Account"/>
				<xsl:if test="AccCurr">
					<xsl:text> / </xsl:text><xsl:value-of select="AccCurr"/>
				</xsl:if>
			</td>
			<td align="right" class="light right"></td>
		</tr>
		<xsl:if test="Ord">
		<tr>
			<td align="left"  class="light"><xsl:text> </xsl:text></td>
			<td align="left"  class="light" colspan="4"><xsl:value-of select="Ord"/></td>
		</tr>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
