﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!--
		Alle nicht abgehandelten Nodes landen hier und es passiert damit nichts
	-->
	<xsl:template match="*">
	</xsl:template>
	
	<xsl:template match="/OASResponse">
		<table width="100%" cellspacing="0" class="overview">
			<xsl:apply-templates select="Batch"/>
		</table>
	</xsl:template>

	<xsl:template match="Batch">
		<tr>
			<td  class="overviewsplitter" width="50%"><xsl:text>.</xsl:text></td>
			<td  class="overviewsplitter" width="45%"></td>
			<td  class="overviewsplitter" width="5%"></td>
		</tr>
		<tr>
			<td align="left" class="light" colspan="3">
				<xsl:value-of select="Ord/Bank"/> / <xsl:value-of select="Ord/Account"/> / <xsl:value-of select="Ord/Adress/Name[@Rel='0']"/>
			</td>
		</tr>
		<tr>
			<th align="left" class="dark">Príjemca</th>
			<th align="right" class="dark" colspan="2">Čiastka</th>
		</tr>
		<tr><td class="overviewsplitter" colspan="3"><xsl:text>.</xsl:text></td></tr>
		<xsl:apply-templates select="Payment">
			<xsl:sort select="NAmount" order="descending" data-type="number"/>
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template name="PaymentSingle">
		<xsl:element name="tr">
			<td align="left"  class="light" id="partner">
				<xsl:value-of disable-output-escaping="yes" select="Ben/Adress/Name[@Rel='0']"/>
				<xsl:text> / </xsl:text>
				<xsl:value-of select="Ben/Bank/Code"/>
				<xsl:text> / </xsl:text>
				<xsl:value-of select="Ben/Account"/>
			</td>
			<td align="right" class="light right" id="amount"><xsl:value-of select="Amount"/><xsl:text> </xsl:text></td>
			<td align="left" class="light right"><xsl:value-of select="Curr"/><xsl:text> </xsl:text></td>
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
